#include "ODEController.h"
#include "ODEBox.h"
#include "ODEWheelCylinder.h"
#include "ODECylinder.h"
#include "ODESphere.h"
#include "ODEWheelJoint.h"
#include "ODEFixedJoint.h"
#include "/home/qaelbdj/Desktop/ode-0.8/include/ode/ode.h"
namespace PhysicsEngine
{

ODEController::ODEController()
{

}

ODEController::~ODEController()
{
}

void ODEController::InitWorld()
{
	ConfigurationServer *conf = ConfigurationServer::GetInstance();
	dInitODE();
	odeworld = dWorldCreate();
	dWorldSetGravity (odeworld,0,0, conf->GetDefaultGravity());
	mainspace = dHashSpaceCreate (0);
	contactgroup = dJointGroupCreate (0);
	dCreatePlane (mainspace,0,0,1,0);
}

void ODEController::ResetWorld()
{
	dJointGroupDestroy (contactgroup);
	dSpaceDestroy (mainspace);
	dWorldDestroy (odeworld);
	dCloseODE();
	bodies.clear();
	spaces.clear();
	ConfigurationServer *conf = ConfigurationServer::GetInstance();
	dInitODE();
	odeworld = dWorldCreate();
	dWorldSetGravity (odeworld,0,0, conf->GetDefaultGravity());
	mainspace = dHashSpaceCreate (0);
	contactgroup = dJointGroupCreate (0);
	dCreatePlane (mainspace,0,0,1,0);
}

IPhysicalBody * ODEController::CreatePhysicalBody(int entityid, DataBody *data)
{
	IPhysicalBody *body=0;
	dGeomID geomid=0;
	if (DataBox *databox = dynamic_cast<DataBox *>(data))
	{
		body = new ODEBox(odeworld, databox->GetBodyId(),databox->GetSize(),databox->GetPosition(),databox->GetRotation(),databox->GetMaterialId(), databox->GetMass(), databox->GetLinearVelocity(), databox->GetAngularVelocity());
		geomid = ((ODEBox *) body)->GetGeomId();
		 
	}	
	else if (DataWheelCylinder *datawheelcylinder = dynamic_cast<DataWheelCylinder *>(data))
	{
		body = new ODEWheelCylinder(odeworld,datawheelcylinder->GetBodyId(), datawheelcylinder->GetRadius(), datawheelcylinder->GetLength(), datawheelcylinder->GetPosition(),datawheelcylinder->GetRotation(),datawheelcylinder->GetMaterialId(), datawheelcylinder->GetMass(), datawheelcylinder->GetLinearVelocity(), datawheelcylinder->GetAngularVelocity());
		geomid = ((ODEWheelCylinder *) body)->GetGeomId();
	}
	else if (DataSphere *datasphere = dynamic_cast<DataSphere *>(data))
	{
		body = new ODESphere(odeworld, datasphere->GetBodyId(), datasphere->GetRadius(), datasphere->GetPosition(), datasphere->GetRotation(), datasphere->GetMaterialId(), datasphere->GetMass(), datasphere->GetLinearVelocity(), datasphere->GetAngularVelocity());
		geomid = ((ODESphere *) body)->GetGeomId();
	}
	else if (DataCylinder *datacylinder = dynamic_cast<DataCylinder *>(data))
	{
		body = new ODECylinder(odeworld,datacylinder->GetBodyId(), datacylinder->GetRadius(), datacylinder->GetLength(), datacylinder->GetPosition(),datacylinder->GetRotation(),datacylinder->GetMaterialId(), datacylinder->GetMass(), datacylinder->GetLinearVelocity(), datacylinder->GetAngularVelocity());
		geomid = ((ODECylinder *) body)->GetGeomId();
	}
	bodies.insert(make_pair((int)geomid, body));
	if (spaces.find(entityid)==spaces.end())
	{
		dSpaceID newspace = dSimpleSpaceCreate (mainspace);
		dSpaceSetCleanup (newspace,0);
		spaces.insert(make_pair(entityid, newspace));
	}
	dSpaceAdd (spaces.find(entityid)->second, geomid);
	return body;
}

IPhysicalJoint* ODEController::CreatePhysicalJoint(DataJoint *data, IPhysicalBody *body1, IPhysicalBody *body2)
{
	dGeomID idbody1;
	

	if (ODEBox *odebox = dynamic_cast<ODEBox *>(body1))
	{
		idbody1 = odebox->GetGeomId();
	}
	else if (ODEWheelCylinder *odewheelcylinder = dynamic_cast<ODEWheelCylinder *>(body1))
	{
		idbody1 = odewheelcylinder->GetGeomId();
	}
	else if (ODESphere *odesphere = dynamic_cast<ODESphere *>(body1))
	{
		idbody1 = odesphere->GetGeomId();
	}
	else if (ODECylinder *odecylinder = dynamic_cast<ODECylinder *>(body1))
	{
		idbody1 = odecylinder->GetGeomId();
	}
	
	dGeomID idbody2;
	if (ODEBox *odebox = dynamic_cast<ODEBox *>(body2))
	{
		idbody2 = odebox->GetGeomId();
	}
	else if (ODEWheelCylinder *odewheelcylinder = dynamic_cast<ODEWheelCylinder *>(body2))
	{
		idbody2 = odewheelcylinder->GetGeomId();
	}
	else if (ODESphere *odesphere = dynamic_cast<ODESphere *>(body2))
	{
		idbody2 = odesphere->GetGeomId();
	}
	else if (ODECylinder *odecylinder = dynamic_cast<ODECylinder *>(body1))
	{
		idbody1 = odecylinder->GetGeomId();
	}
	
	IPhysicalJoint *joint=0;

	if (DataWheelJoint *datawheeljoint = dynamic_cast<DataWheelJoint *>(data))
	{
		joint = new ODEWheelJoint(odeworld,datawheeljoint->GetJointId(), body1, body2, datawheeljoint->GetAxis1(),datawheeljoint->GetAxis2(), datawheeljoint->GetHardness(), datawheeljoint->GetBounciness(),  datawheeljoint->GetMaxTorque());
		((ODEWheelJoint*) joint)->ApplyJointVelocity(datawheeljoint->GetVelocity());
	}	
	else if (DataFixedJoint *datafixedjoint = dynamic_cast<DataFixedJoint *>(data))
	{
		joint = new ODEFixedJoint(odeworld, datafixedjoint->GetJointId(), body1, body2); 
	}
	return joint;
}

void ODEController::StepWorld(float timestep, int steps, bool fastmode)
{
	for (int i=0; i<steps; i++)
	{
		dSpaceCollide(mainspace, this, &nearCollisionCallback);
		if (!fastmode)
		{
			dWorldStep (odeworld,timestep);
		}
		else
		{
			dWorldQuickStep(odeworld,timestep);
		}
		dJointGroupEmpty(this->contactgroup);
	}
}

DataInteraction ODEController::GetDefaultInteraction()
{
	ConfigurationServer *conf = ConfigurationServer::GetInstance();
	DataInteraction dataint(conf->GetDefaultHardnessInteraction(), conf->GetDefaultBouncinessInteraction(), conf->GetDefaultSlip1Interaction(),conf->GetDefaultSlip2Interaction(), conf->GetDefaultFrictionInteraction());
	return dataint;
}	
void nearCollisionCallback(void* _this, dGeomID id1, dGeomID id2)
{
	if (dGeomIsSpace(id1) || dGeomIsSpace(id2))
	{
		dSpaceCollide2(id1,id2,_this,&nearCollisionCallback);
		/*If I want internal collision it should be done here*/
	}
	else
	{
		int i,n;		
		dBodyID b1 = dGeomGetBody(id1);
		dBodyID b2 = dGeomGetBody(id2);
		if (b1 && b2 && dAreConnected(b1, b2))
			return;
		
		ConfigurationServer *conf = ConfigurationServer::GetInstance();
		int N = conf->GetContactPointsAmmount();
		dContact contact[N];
		n = dCollide (id1,id2,N,&contact[0].geom,sizeof(dContact));
		map<int, IPhysicalBody*>::iterator it;
		map<int, IPhysicalBody*> bodies = ((ODEController *)_this)->bodies; 
		it = bodies.find((int)id1);
		IPhysicalBody *body1 = 0;
		if (it!=bodies.end())
		{
			body1 = it->second;
		}
		IPhysicalBody *body2 = 0;
		
		it = bodies.find((int)id2);
		if (it!=bodies.end())
		{
			body2 = it->second;
		}
		if (!(dynamic_cast<IPhysicalWheelCylinder *>(body1) &&dynamic_cast<IPhysicalWheelCylinder *>(body2)))
		{
			MaterialManager *matman = MaterialManager::GetInstance();
			for (i=0; i<n; i++) 
			{
				DataInteraction interaction;
				if (body1==0||body2==0)
				{
					interaction = ((ODEController *)_this)->GetDefaultInteraction();
				}
				else
				{					
					interaction = matman->GetDataInteraction(body1->GetMaterialId(),body2->GetMaterialId());
				}
				contact[i].surface.mode = dContactSlip1 | dContactSlip2 |
				dContactSoftERP | dContactSoftCFM | dContactApprox1;
				contact[i].surface.slip1 = interaction.GetSlip1();
				contact[i].surface.slip2 = interaction.GetSlip2();
				contact[i].surface.soft_erp = interaction.GetBounciness();
				contact[i].surface.soft_cfm = interaction.GetHardness();
				contact[i].surface.mu = interaction.GetFriction();
				dJointID c = dJointCreateContact (((ODEController *)_this)->odeworld,((ODEController *)_this)->contactgroup,&contact[i]);
				dJointAttach (c,dGeomGetBody(contact[i].geom.g1),dGeomGetBody(contact[i].geom.g2));
			}
		}
	}
}

string ODEController::GetDrawData()
{
	string data = "<DrawData>";
	std::map<int, IPhysicalBody*>::iterator iter;
		
	iter = bodies.begin();
	while (iter!=bodies.end())
	{
		iter->second->UpdateData();
		DataBody *databd =iter->second->GetDataBody(); 
		data += databd->ToString();
		delete databd;
		iter++;
	}
	data+= "</DrawData>";
	return data;
}

map<int, IPhysicalBody *> ODEController::GetBodies()
{
	return this->bodies;
}

void ODEController::SetWorldHardness(float hardness)
{
	dWorldSetCFM(odeworld, hardness);
}
void ODEController::SetWorldBounciness(float bounciness)
{
	dWorldSetERP(odeworld, bounciness);
}

void ODEController::SetWorldGravity(float gravx, float gravy, float gravz)
{
	dWorldSetGravity(odeworld,gravx,gravy,gravz);
}

void ODEController::FreeResources()
{
	dSpaceDestroy(mainspace);
	dWorldDestroy(odeworld);
	dCloseODE();
}


}
